use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
-- 66552 DEV-91052
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[A4S_sp_SetSentimentDashboardStatus_V2]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[A4S_sp_SetSentimentDashboardStatus_V2]
'

declare @ClientPayload02 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_SetSentimentDashboardStatus_V2]
    @surveyId INT,
    @questionName NVARCHAR(255),
    @isDashboardCreated BIT,
	@status VARCHAR(25),
	@errorMessage NVARCHAR(MAX)
AS
BEGIN
     DECLARE @schemaName nvarchar(40)
     DECLARE @stmt nvarchar(max)

     SET @schemaName = [dbo].GetProjectSchema(@surveyId)
     SET @stmt = ''IF EXISTS (SELECT * FROM ''+@schemaName+''.SentimentDashboardStatus WHERE QuestionName=@questionName)
    BEGIN
      UPDATE ''+@schemaName+''.[SentimentDashboardStatus] 
      SET IsDashboardCreated = @isDashboardCreated, 
				modifiedBy = NULL, 
				modified = GETUTCDATE(),
				status=@status,
				errorMessage=@errorMessage
      WHERE QuestionName=CONVERT(VARCHAR, @questionName)
     END
     ELSE
     BEGIN
     INSERT INTO ''+ @schemaName+''.[SentimentDashboardStatus]
        ([IsDashboardCreated]
        ,[modifiedBy]
        ,[modified]
		,[ResponseVariableId]
		 ,[QuestionName]
		 ,[status]
		 ,[errorMessage])
        VALUES(
        @isDashboardCreated
        ,NULL
        ,GETUTCDATE(),
		0
     ,@questionName
	 ,@status
	 ,@errorMessage)
     END''
               
     EXEC sp_executesql @stmt, N''@questionName NVARCHAR(255), @isDashboardCreated BIT, @status VARCHAR(25), @errorMessage NVARCHAR(MAX)'', @questionName, @isDashboardCreated, @status, @errorMessage
     END
'

declare @ClientPayload03 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[A4S_sp_GetSentimentDashboardStatus]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[A4S_sp_GetSentimentDashboardStatus]
'

declare @ClientPayload04 nvarchar(max) = N'
CREATE PROCEDURE [dbo].A4S_sp_GetSentimentDashboardStatus    
     @surveyId INT,              
     @questionName NVARCHAR(255)              
AS              
BEGIN              
  DECLARE @schemaName nvarchar(40)              
  DECLARE @stmt nvarchar(max)              
        
  SET @schemaName = [dbo].GetProjectSchema(@surveyId)              
  SET @stmt = ''        
SELECT TOP 1 IsDashboardCreated, modified,Status,HasLanguageDetect         
  FROM '' +@schemaName +''.[SentimentDashboardStatus]              
  WHERE QuestionName=@questionName       
  ORDER BY  modified desc''              
          
  EXEC sp_executesql @stmt , N''@questionName NVARCHAR(255)'', @questionName                    
END
'

declare @ClientPayload05 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[A4S_sp_GetSentimentDashboardStatus_V2]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[A4S_sp_GetSentimentDashboardStatus_V2]
'

declare @ClientPayload06 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_GetSentimentDashboardStatus_V2]         
     @surveyId INT,                    
     @questionName NVARCHAR(255)                     
AS                    
BEGIN                    
  DECLARE @schemaName nvarchar(40)                    
  DECLARE @stmt nvarchar(max)                    
              
  SET @schemaName = [dbo].GetProjectSchema(@surveyId)                    
  SET @stmt = ''              
SELECT TOP 1 IsDashboardCreated, modified,Status,HasLanguageDetect,BatchStatus,TopicBatchStatus               
  FROM '' +@schemaName +''.[SentimentDashboardStatus]                    
  WHERE QuestionName=@questionName               
  ORDER BY  modified desc''                    
                
  EXEC sp_executesql @stmt , N''@questionName NVARCHAR(255)'', @questionName                       
END
'

declare @ClientPayload07 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[A4S_sp_SetSentimentDashboardBatchStatus]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[A4S_sp_SetSentimentDashboardBatchStatus]
'

declare @ClientPayload08 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_SetSentimentDashboardBatchStatus]          
    @surveyId INT,          
    @questionName NVARCHAR(255),          
    @status VARCHAR(25),    
    @hasSentimentAnalysis BIT,    
    @hasTopicAnalysis BIT    
AS          
BEGIN          
     DECLARE @schemaName nvarchar(40)          
     DECLARE @stmt nvarchar(max)          
      
     SET @schemaName = [dbo].GetProjectSchema(@surveyId)          
     SET @stmt = ''IF EXISTS (SELECT * FROM ''+@schemaName+''.SentimentDashboardStatus WHERE QuestionName=@questionName)          
    BEGIN    
  IF (@hasSentimentAnalysis = 1 AND @hasTopicAnalysis = 1)    
   BEGIN     
     UPDATE ''+@schemaName+''.[SentimentDashboardStatus]           
     SET [BatchStatus]=@status     
      ,[TopicBatchStatus]=@status     
     WHERE QuestionName=@questionName   
   END    
  ELSE IF (@hasSentimentAnalysis = 1)    
   BEGIN     
    UPDATE ''+@schemaName+''.[SentimentDashboardStatus]           
     SET [BatchStatus]=@status     
     WHERE QuestionName=@questionName
   END    
  ELSE IF (@hasTopicAnalysis = 1)    
   BEGIN     
    UPDATE ''+@schemaName+''.[SentimentDashboardStatus]           
      SET [TopicBatchStatus]=@status     
     WHERE QuestionName=@questionName  
   END    
     END          
     ELSE          
     BEGIN          
     INSERT INTO ''+ @schemaName+''.[SentimentDashboardStatus]          
        ([BatchStatus]  ,[TopicBatchStatus] , [ResponseVariableId]    
   ,[QuestionName] )          
        VALUES(@status,@status, 0       
  ,@questionName        
  )          
     END''          
      
 EXEC sp_executesql @stmt, N''@questionName NVARCHAR(255), @status VARCHAR(25),@hasSentimentAnalysis BIT, @hasTopicAnalysis BIT'', @questionName, @status,@hasSentimentAnalysis,@hasTopicAnalysis          
 END     
'

declare @ClientPayload09 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[A4S_sp_RenameResponsesVariables]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[A4S_sp_RenameResponsesVariables]
'

declare @ClientPayload10 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_RenameResponsesVariables]
 @surveyId INT,
 @deployedVersion INT
AS
BEGIN
 DECLARE @RenamedVariables TABLE ( [VariableId] int, [NewName] nvarchar(255), [OldName] nvarchar(255) ) 
  
 INSERT INTO @RenamedVariables ([VariableId], [NewName], [OldName])
 SELECT v.[Id], v.[Name], v2.[Name] as ''OldName''
   FROM [SAT].[Variables] v
   INNER JOIN [SAT].[BlockItems] bi ON v.QuestionId = bi.Id AND bi.[Version] = @deployedVersion
   INNER JOIN [SAT].[Blocks] b ON bi.BlockId = b.Id AND b.[Version] = @deployedVersion
   INNER JOIN [SAT].[QuestionnaireVersions] qv ON b.QuestionnaireId = qv.Id AND qv.[Version] = @deployedVersion
   INNER JOIN [SAT].Variables v2 ON v.[Id] = v2.[Id] 
   WHERE qv.Id = @surveyId and v.[Version] = @deployedVersion and v2.[Version] = @deployedVersion - 1 and v.[Name] <> v2.[Name]
   
 IF ((SELECT COUNT(*) FROM @RenamedVariables) > 0)
 BEGIN
  DECLARE renamedVariablesCursor CURSOR FOR SELECT [OldName], [NewName] FROM @RenamedVariables
  DECLARE @oldName NVARCHAR(255)
  DECLARE @newName NVARCHAR(255)
  
  DECLARE @schemaName nvarchar(40) = [dbo].GetProjectSchema(@surveyId);
  DECLARE @updateQuery NVARCHAR (150) = ''UPDATE TOP (10000) '' + @schemaName + ''.[Response] SET RpsQuestion = @newName WHERE [RpsQuestion] = @oldName''
  DECLARE @updateRespondentVariableDisplayOrderQuery NVARCHAR (150) = ''UPDATE TOP (10000) '' + @schemaName + ''.[RespondentVariableDisplayOrder] SET VariableName = @newName WHERE [VariableName] = @oldName''
  DECLARE @updateRespondentVariableRandomizationQuery NVARCHAR (150) = ''UPDATE TOP (10000) '' + @schemaName + ''.[RespondentVariableRandomization] SET VariableName = @newName WHERE [VariableName] = @oldName''
  DECLARE @updateSentimentDashboardStatusVariableName NVARCHAR (150) = ''UPDATE '' + @schemaName + ''.[SentimentDashboardStatus] SET QuestionName = @newName WHERE [QuestionName] = @oldName''

  DECLARE @countQuery NVARCHAR (150) = ''SELECT @questionCountOUT = COUNT([RpsQuestion]) FROM '' + @schemaName + ''.[Response] WHERE RpsQuestion = @oldName''
  DECLARE @questionCount INT
  
  OPEN renamedVariablesCursor;
  FETCH NEXT FROM renamedVariablesCursor INTO @oldName, @newName;
  WHILE @@FETCH_STATUS = 0 BEGIN
   EXEC sp_executesql @countQuery, N''@oldName nvarchar(255), @questionCountOUT int OUTPUT'',  @oldName=@oldName, @questionCountOUT=@questionCount OUTPUT 
   WHILE ( @questionCount > 0 )
   BEGIN
    BEGIN TRANSACTION
    EXEC sp_executesql @updateQuery, N''@oldName nvarchar(255), @newName nvarchar(255)'', @oldName=@oldName, @newName=@newName
    COMMIT

    BEGIN TRANSACTION
    EXEC sp_executesql @updateRespondentVariableDisplayOrderQuery, N''@oldName nvarchar(255), @newName nvarchar(255)'', @oldName=@oldName, @newName=@newName
    COMMIT

	 BEGIN TRANSACTION
    EXEC sp_executesql @updateRespondentVariableRandomizationQuery, N''@oldName nvarchar(255), @newName nvarchar(255)'', @oldName=@oldName, @newName=@newName
    COMMIT

    EXEC sp_executesql @countQuery, N''@oldName nvarchar(255), @questionCountOUT int OUTPUT'',  @oldName=@oldName, @questionCountOUT=@questionCount OUTPUT 
   END
   FETCH NEXT FROM renamedVariablesCursor INTO @oldName, @newName;
  END
  
  CLOSE renamedVariablesCursor
  DEALLOCATE renamedVariablesCursor  
 END

  BEGIN TRANSACTION
  EXEC sp_executesql @updateSentimentDashboardStatusVariableName, N''@oldName nvarchar(255), @newName nvarchar(255)'', @oldName=@oldName, @newName=@newName
  COMMIT
 
 SELECT * FROM @RenamedVariables
END
'

declare @ClientPayload11 nvarchar(max) = N'
-- 66558 DEV-91052
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[A4S_sp_GetCompletedNewResponsesForBatchUpdate]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[A4S_sp_GetCompletedNewResponsesForBatchUpdate]
'

declare @ClientPayload12 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_GetCompletedNewResponsesForBatchUpdate]         
    @surveyId INT,            
    @questionName NVARCHAR(255),
    @variableId INT
AS  
BEGIN        
    DECLARE @schemaName NVARCHAR(MAX) = [dbo].GetProjectSchema(@surveyId)         
  
 -- Responses are "completed" if the respondent has completed the survey  
 -- Responses are new if they have no sentiment data  
    DECLARE @query NVARCHAR(MAX) =   
  ''SELECT   
    response.[RpsRespondent]  
   ,response.[RpsMatrix]  
   ,response.[RpsMention]  
   ,response.[RpsContent]  
   ,response.[RpsOpened]   
   ,response.[RpsQuestion] 
  FROM '' + @schemaName +''.[Response] response   
   INNER JOIN '' + @schemaName +''.[Respondent] respondent ON response.[RpsRespondent] = respondent.[ResRespondent]   
   LEFT JOIN '' + @schemaName + ''.[SentimentData] sentimentData   
    ON response.[RpsRespondent] = sentimentData.[RespondentId]   
    AND response.[RpsQuestion] = sentimentData.[QuestionName]  
    AND response.[RpsMatrix] = sentimentData.[ResponseMatrix]  
    AND response.[RpsMention] = sentimentData.[ResponseMention]  
  WHERE   
   respondent.[ResCompleted] = 1  
   AND (sentimentData.[Id] IS NULL OR sentimentData.[ResponseVariableId] <> @variableId)
   AND response.[RpsQuestion] = @questionName  
   AND ((response.[RpsOpened] IS NOT NULL   
   AND LTRIM(response.[RpsOpened]) <> '''''''')  
   OR (response.[RpsContent] IS NOT NULL  
   AND LTRIM(response.[RpsContent]) <> ''''''''   
   AND response.[RpsContent] <> ''''0'''')) ''   
      
 EXEC sp_executesql @query, N''@questionName NVARCHAR(255), @variableId INT'', @questionName , @variableId 
END 
'

declare @ClientPayload13 nvarchar(max) = N'
-- 66562 DEV-72312
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[A4S_sp_GetRespondents]'') AND TYPE IN (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[A4S_sp_GetRespondents]
'

declare @ClientPayload14 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_GetRespondents]
    @surveyId INT,
    @filterQuery NVARCHAR(MAX),
    @variables NVARCHAR(MAX) = NULL,
    @search NVARCHAR(255) = '''',
    @advancedFilter NVARCHAR(MAX) = '''',
    @sort NVARCHAR(255) = '''',
    @startIndex INT = 1,
    @endIndex INT = 10,
    @hidePersonalData BIT = 0
AS
BEGIN

DECLARE @schemaName NVARCHAR(40)
DECLARE @stmt NVARCHAR(MAX)
DECLARE @innerQuery NVARCHAR(MAX)
DECLARE @variableColumns NVARCHAR(MAX) = ''''
DECLARE @variable NVARCHAR(256)
DECLARE @variablesQuery NVARCHAR(MAX) = ''''
DECLARE @variablesSearchQuery NVARCHAR(MAX) = ''''
DECLARE @piiSearchQuery NVARCHAR(MAX) = ''''
DECLARE @variableIndex INT

SET @schemaName = [dbo].GetProjectSchema(@surveyId)

IF (@sort IS NULL OR LEN(@sort) <= 0) 
    SET @sort = ''[Id]''

IF (@advancedFilter IS NOT NULL AND LEN(@advancedFilter) > 0) 
    SET @advancedFilter = '' AND '' + @advancedFilter

IF (@hidePersonalData = 0) 
    SET @piiSearchQuery = ''OR ISNULL([Email], '''''''') LIKE ''''%'' + @search + ''%''''''


IF (LEN(@variables) > 0)
    BEGIN
        SET @variableIndex = 0
        SET @variableColumns = ''''

        WHILE LEN(@variables) > 0 AND @variableIndex < 10
            BEGIN
                IF PATINDEX(''%,%'',@variables) > 0
                    BEGIN
                        SET @variable = SUBSTRING(@variables, 0, PATINDEX(''%,%'',@variables))
                        SET @variables = SUBSTRING(@variables, LEN(@variable + '','') + 1, LEN(@variables))
                    END
                ELSE
                    BEGIN
                        SET @variable = @variables
                        SET @variables = NULL
                    END

                SET @variablesQuery += '',STUFF(
                    (
                        SELECT '''','''' + RpsContent
                        FROM '' + @schemaName + ''.Response r WITH(NOLOCK)
                        WHERE r.RpsQuestion = '''''' + @variable + ''''''
                        AND r.RpsRespondent = filterQuery.ResRespondent
                        ORDER BY RpsMatrix, RpsMention
                        FOR XML PATH(''''''''),
                        TYPE
                    ).value(''''.'''', ''''NVARCHAR(MAX)''''),
                    1, 1, ''''''''
                ) AS Variable'' + CONVERT(NVARCHAR, @variableIndex) + ''''

                SET @variablesSearchQuery += '' OR Variable'' + CONVERT(NVARCHAR, @variableIndex) + '' LIKE ''''%'' + @search + ''%''''''

                SET @variableColumns += '', Variable'' + CONVERT(NVARCHAR, @variableIndex)
                SET @variableIndex += 1
            END
    END


SET @innerQuery = ''(
    SELECT ResRespondent AS [Id],
        ResPIN AS [Pin],
        ResLanguageCode AS [Language],
        ResEmail AS [Email],
        EH AS [EmailStatus],
        ResPhone AS [Phone],
        PH AS [PhoneStatus],
        ResTimeZone AS [TimeZone],
        ResDisposition AS [Disposition],
        [TotalDuration],
        ResActive AS [Active],
        CONVERT(bit, IsSimulatedRespondent) AS [Simulated], 
        [DeviceType],
        [DeviceOs],
        [DeviceOsVersion],
        [DeviceBrowser],
        [DeviceBrowserVersion],
        Location AS [Location],
        OfflineUserId AS [OfflineUserId],
        OfflineUUID AS [OfflineUUID],
        u.[UserName] AS [OfflineUserName],
        (
            SELECT TOP (1) HisCallDate
            FROM ''+@schemaName+''.[Historic]
            WHERE HisRespondent = ResRespondent 
            ORDER BY HisCallNumber ASC
        ) AS [FirstActivity],
        ResLastCallDate AS [LastActivity],
        AppointmentDate AS [AppointmentDate],
        modified AS [ModifiedOn],
        ResLastCompQuestName AS [LastAnsweredQuestion],
        (
            SELECT MAX(modified)
            FROM ''+@schemaName+''.[Response]
            WHERE RpsRespondent = ResRespondent
        ) AS [LastAnswerDate],
        AccessExpirationDate,
        PanelistId,
        IsAnonymized AS [IsAnonymized]'' + @variablesQuery + ''
    FROM ('' + @filterQuery + '') AS filterQuery
        LEFT JOIN [Users] u ON [OfflineUserId] = u.[Id]
) AS subquery''

DECLARE @searchQuery NVARCHAR(MAX)
IF (@search IS NOT NULL AND LEN(@search) > 0)
BEGIN
 SET @searchQuery = ''(
        CONVERT(nvarchar, [Id]) = '''''' + @search + ''''''
        OR ISNULL([Pin], '''''''') LIKE ''''%'' + @search + ''%''''''
        + @piiSearchQuery
        + @variablesSearchQuery + ''
    )''
END
ELSE
BEGIN
 SET @searchQuery = ''1=1''
END

SET @stmt = ''SELECT rowquery.[Id],
    [Pin],
    [Language],
    rowquery.[Email],
    [EmailStatus],
    [Phone],
    [PhoneStatus],
    [TimeZone],
    [Disposition],
    [TotalDuration],
    rowquery.[Active],
    [Simulated],
    [DeviceType],
    [DeviceOs],
    [DeviceOsVersion],
    [DeviceBrowser],
    [DeviceBrowserVersion],
    [Location],
    [OfflineUserId],
    [OfflineUserName],
    [OfflineUUID],
    [FirstActivity],
    [LastActivity],
    [AppointmentDate],
    [ModifiedOn],
    [LastAnsweredQuestion],
    [LastAnswerDate],
    [AccessExpirationDate],
    [IsAnonymized],
    [PanelistId]
    '' + @variableColumns + ''
    FROM (
        SELECT ROW_NUMBER() OVER (ORDER BY '' + @sort + '') AS [RowNum], *
        FROM '' + @innerQuery + ''
        WHERE '' + @searchQuery + @advancedFilter + ''
    ) AS rowquery
    WHERE [RowNum] >= @startIndex
        AND [RowNum] <= @endIndex
    ORDER BY [RowNum]''

EXEC sp_executesql @stmt, N''@startIndex INT, @endIndex INT'', @startIndex, @endIndex

SET @stmt = ''SELECT COUNT(1) AS [TotalRecords] FROM '' + @innerQuery 
EXEC sp_executesql @stmt

IF (@search IS NOT NULL AND LEN(@search) > 0) OR (@advancedFilter IS NOT NULL AND LEN(@advancedFilter) > 0)
    BEGIN
        SET @stmt = ''SELECT COUNT(1) AS [TotalDisplayedRecords] 
            FROM '' + @innerQuery + ''
            WHERE '' + @searchQuery + @advancedFilter
        EXEC sp_executesql @stmt
    END
END
'

declare @ClientPayload15 nvarchar(max) = N'
-- 66565 DEV-91512
IF EXISTS(SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[A4S_sp_GetRespondentResponses]'') AND TYPE in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[A4S_sp_GetRespondentResponses]
'

declare @ClientPayload16 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_GetRespondentResponses]
     @surveyId INT,
     @respondentId INT,
     @search NVARCHAR(255) = '''',
     @advancedFilter nvarchar(MAX) = '''',
     @sort NVARCHAR(255) = '''',
     @startIndex INT = 1,
     @endIndex INT = 10
AS
BEGIN
     DECLARE @schemaName nvarchar(40)
     SET @schemaName = [dbo].GetProjectSchema(@surveyId)
     DECLARE @stmt nvarchar(max) 
     DECLARE @innerQuery nvarchar(max)
     DECLARE @DefaultViewedUnansweredQuestionCode nvarchar(max) = null

     IF (@sort IS NULL OR LEN(@sort) <= 0 ) SET @sort = ''[Position]''

     IF (@advancedFilter IS NOT NULL AND LEN(@advancedFilter) > 0 ) SET @advancedFilter = '' AND '' + @advancedFilter

     IF EXISTS (select * from sys.columns where [object_id] = object_id(''[SAT].[SurveyOptions]'') and [name] = ''DefaultViewedUnansweredQuestionCode'')
      BEGIN
         SELECT @DefaultViewedUnansweredQuestionCode = so.[DefaultViewedUnansweredQuestionCode] FROM SAT.SurveyOptions so
         WHERE so.Id = CONVERT(nvarchar, @surveyId) and so.[Version] = 0
      END

     SET @innerQuery = ''(SELECT ROW_NUMBER() OVER (ORDER BY b.Position, bi.Position, v.Id) AS [Position], b.Name AS [Block], q.Name AS [Question], q.[Type_Id] as [QuestionTypeId], ''
 
       IF @DefaultViewedUnansweredQuestionCode IS NOT NULL
       BEGIN
        SET @innerQuery += 
        ''CASE WHEN EXISTS (SELECT * FROM '' + @schemaName + ''.[RespondentTraversedQuestions] rtq 
             WHERE rtq.[ResRespondent] = @respondentId
             AND rtq.QuestionId = q.Id)
        THEN 1
        ELSE 0
        END as IsQuestionTraversed, ''

        SET @innerQuery += 
        ''CASE WHEN EXISTS (SELECT * FROM '' + @schemaName + ''.[RespondentDisplayedVariables] rdv 
             WHERE rdv.[ResRespondent] = @respondentId
             AND rdv.VariableName = v.Name)
        THEN 1
        ELSE 0
        END as IsVariableDisplayed, ''
       END
 
       SET @innerQuery += '' STUFF((SELECT '''', ''''+ t.[Text] FROM [SAT].[LocalizableTexts] AS t 
        INNER JOIN [SAT].[LocalizableTexts_QuestionText] AS qt ON t.[Id]=qt.[Id] 
        WHERE qt.[Version]=0 AND t.[Version]=0 AND t.[Language]=so.[DefaultLanguage] AND qt.[QuestionId]=q.[Id] 
     FOR XML PATH(''''''''), TYPE).value(''''.'''',''''NVARCHAR(MAX)''''),1,2,'''' '''') 
     AS [QuestionText], 
        v.Name AS [Variable], v.DataType AS [VariableDataType], ISNULL(r1.RpsMatrix, 1) As [Row],
        STUFF((SELECT '''', '''' + RpsContent
           FROM '' + @schemaName + ''.Response r2
           WHERE r2.RpsQuestion = v.Name
           AND r2.RpsMatrix = ISNULL(r1.RpsMatrix, 1)
           AND r2.RpsRespondent = r1.RpsRespondent
           ORDER BY RpsMention
           FOR XML PATH(''''''''), TYPE).value(''''.'''', ''''nvarchar(max)''''), 1, 1, '''''''')        
        AS [Content],
        STUFF((SELECT '''', '''' + SUBSTRING(RpsOpened, 0, 255)
           FROM '' + @schemaName + ''.Response r2
           WHERE r2.RpsQuestion = v.Name
           AND r2.RpsMatrix = ISNULL(r1.RpsMatrix, 1)
           AND r2.RpsRespondent = r1.RpsRespondent
           AND DATALENGTH(RpsOpened) > 0
           ORDER BY RpsMention
           FOR XML PATH(''''''''), TYPE).value(''''.'''', ''''nvarchar(max)''''), 1, 1, '''''''')
         AS [OpenEnd]
       FROM SAT.Variables v
       LEFT JOIN '' + @schemaName + ''.Response r1 ON r1.RpsQuestion = v.Name AND RpsRespondent = @respondentId
       INNER JOIN SAT.BlockItems_Question q ON v.QuestionId = q.Id AND q.Version = 0
       INNER JOIN SAT.BlockItems bi ON q.Id = bi.Id AND bi.Version = 0
       INNER JOIN SAT.Blocks b ON bi.BlockId = b.Id AND b.Version = 0
       INNER JOIN SAT.SurveyOptions so ON b.QuestionnaireId = so.Id and so.Version = 0
       WHERE b.QuestionnaireId = @surveyId AND v.Version = 0 AND q.Type_Id != 36
        GROUP BY r1.RpsRespondent, b.Position, b.Name, bi.Position, so.DefaultLanguage, q.Id, q.Name, v.Id, v.Name, v.DataType, q.[Type_Id], ISNULL(r1.RpsMatrix, 1)) AS subquery''
    
     SET @stmt = ''SELECT [Position], [Block], [Question], [QuestionText], [Variable], [VariableDataType], [Row], ''
  
     IF @DefaultViewedUnansweredQuestionCode IS NULL
     BEGIN
      SET @stmt += ''[Content], ''
     END
     ELSE
     BEGIN
      SET @stmt += ''COALESCE(NULLIF(LTRIM(RTRIM([Content])), ''''''''), (SELECT CASE WHEN IsQuestionTraversed = 1 AND IsVariableDisplayed = 1 AND QuestionTypeId NOT IN (32) THEN '''''' + @DefaultViewedUnansweredQuestionCode + '''''' ELSE NULL END)) as Content, ''
     END

      SET @stmt += 
      ''[OpenEnd] FROM
      (SELECT ROW_NUMBER() OVER (ORDER BY '' + @sort + '') AS [RowNum], * 
      FROM '' + @innerQuery + '' WHERE ([Block] LIKE ''''%'' + @search + ''%'''' OR [Question] LIKE ''''%'' + @search + ''%'''' OR [Variable] LIKE ''''%'' + @search + ''%'''' OR [Content] LIKE ''''%'' + @search + ''%'''')'' + @advancedFilter + '') rowquery
      WHERE [RowNum] >= '' + CONVERT(nvarchar, @startIndex) + '' AND [RowNum] <= '' + CONVERT(nvarchar, @endIndex) + ''
      ORDER BY [RowNum]''

     EXEC sp_executesql @stmt, N''@respondentId INT, @surveyId INT'', @respondentId, @surveyId
     SET @stmt = ''SELECT COUNT(*) AS [TotalRecords] FROM '' + @innerQuery
     EXEC sp_executesql @stmt, N''@respondentId INT, @surveyId INT'', @respondentId, @surveyId
 
     IF (@search IS NOT NULL AND LEN(@search) > 0) OR (@advancedFilter IS NOT NULL AND LEN(@advancedFilter) > 0)
     BEGIN
      SET @stmt = ''SELECT COUNT(*) AS [TotalDisplayedRecords] FROM '' + @innerQuery + '' WHERE ([Block] LIKE ''''%'' + @search + ''%'''' OR [Question] LIKE ''''%'' + @search + ''%'''' 
         OR [Variable] LIKE ''''%'' + @search + ''%'''' OR [Content] LIKE ''''%'' + @search + ''%'''')'' + @advancedFilter
      EXEC sp_executesql @stmt, N''@respondentId INT, @surveyId INT'', @respondentId, @surveyId
     END 
    END
'

declare @SurveyPayload01 nvarchar(max) = N'
-- 66211 DEV-91052
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[SentimentDashboardStatus]'') AND type in (N''U''))
AND NOT EXISTS (SELECT 1 FROM sys.columns WHERE [object_id] = object_id(''#SURVEY SCHEMA#.[SentimentDashboardStatus]'') AND [name] = ''QuestionName'')
BEGIN
     ALTER TABLE #SURVEY SCHEMA#.SentimentDashboardStatus
     ADD QuestionName NVARCHAR(255)
END
'

declare @SurveyPayload02 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[SentimentDashboardStatus]'') AND type in (N''U''))
AND EXISTS (SELECT 1 FROM sys.columns WHERE [object_id] = object_id(''#SURVEY SCHEMA#.[SentimentDashboardStatus]'') AND [name] = ''QuestionName'')
BEGIN
    UPDATE s
    SET s.[QuestionName] = v.[Name]
    FROM #SURVEY SCHEMA#.[SentimentDashboardStatus] s
    INNER JOIN [SAT].[Variables] v ON s.[ResponseVariableId] = v.[Id] AND v.[Version] = 0
    WHERE s.[QuestionName] IS NULL AND s.[ResponseVariableId] <> 0
END
'
declare @SurveyPayload03 nvarchar(max) = N'
-- 66212 DEV-91512
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[RespondentDisplayedVariables]'') AND TYPE in (N''U''))
BEGIN
    CREATE TABLE #SURVEY SCHEMA#.[RespondentDisplayedVariables](
        [ResRespondent] [int] NOT NULL,
		[VariableName] nvarchar(255) NOT NULL,
		[Matrix] [int] NOT NULL,
		CONSTRAINT PK_RespondentDisplayedVariables PRIMARY KEY CLUSTERED (ResRespondent, VariableName, Matrix),
		CONSTRAINT FK_RespondentDisplayedVariables_Respondent FOREIGN KEY (ResRespondent) 
		REFERENCES #SURVEY SCHEMA#.[Respondent](ResRespondent)
		ON DELETE CASCADE
	)
END
'

declare @SurveyPayload04 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[VSE_sp_UpdateRespondentDisplayedVariables]'') AND schema_Id <> SCHEMA_ID(''dbo'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE #SURVEY SCHEMA#.[VSE_sp_UpdateRespondentDisplayedVariables]
'

declare @SurveyPayload05 nvarchar(max) = N'
CREATE PROCEDURE #SURVEY SCHEMA#.[VSE_sp_UpdateRespondentDisplayedVariables]
	@ResRespondent INT,
	@VariableNames NVARCHAR(MAX),
    @Matrix INT
AS
    DECLARE @stmt nvarchar(MAX) = ''
        INSERT INTO #SURVEY SCHEMA#.[RespondentDisplayedVariables] 
        SELECT
            @ResRespondent,
            ids,
            @Matrix
        FROM 
        (
            values '' + @VariableNames + ''
        ) as t(ids) 
        WHERE 
            ids NOT IN (
                SELECT 
                    VariableName 
                FROM 
                    #SURVEY SCHEMA#.RespondentDisplayedVariables 
                WHERE 
                    ResRespondent = @ResRespondent
                AND
                    Matrix = @Matrix
            )
    ''

    EXEC sp_executesql @stmt, N''@ResRespondent INT, @Matrix INT'', @ResRespondent, @Matrix
'

declare @SurveyPayload06 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[VSE_sp_GetRespondentDisplayedVariables]'') AND schema_Id <> SCHEMA_ID(''dbo'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE #SURVEY SCHEMA#.[VSE_sp_GetRespondentDisplayedVariables]
'

declare @SurveyPayload07 nvarchar(max) = N'
CREATE PROCEDURE #SURVEY SCHEMA#.[VSE_sp_GetRespondentDisplayedVariables]
	@ResRespondent INT
AS
    SELECT
        VariableName,
        Matrix
    FROM #SURVEY SCHEMA#.[RespondentDisplayedVariables]
    WHERE
        ResRespondent = @ResRespondent
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait

        print 'Client Payload 1'
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 2'
		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 3'
		select @SQL = replace(replace(@ClientPayload03, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 4'
		select @SQL = replace(replace(@ClientPayload04, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 5'
		select @SQL = replace(replace(@ClientPayload05, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 6'
		select @SQL = replace(replace(@ClientPayload06, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 7'
		select @SQL = replace(replace(@ClientPayload07, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 8'
		select @SQL = replace(replace(@ClientPayload08, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 9'
		select @SQL = replace(replace(@ClientPayload09, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 10'
		select @SQL = replace(replace(@ClientPayload10, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 11'
		select @SQL = replace(replace(@ClientPayload11, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 12'
		select @SQL = replace(replace(@ClientPayload12, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 13'
		select @SQL = replace(replace(@ClientPayload13, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 14'
		select @SQL = replace(replace(@ClientPayload14, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 15'
		select @SQL = replace(replace(@ClientPayload15, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 16'
		select @SQL = replace(replace(@ClientPayload16, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Payload done!'

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end

	select @TotalSurveys = count(*) from #Survey
	set @SurveyCursor = cursor forward_only for select DBName, SchemaName from #Survey for update of Processed
	open @SurveyCursor
	fetch next from @SurveyCursor into @ThisClient, @ThisSurvey
	while @@FETCH_STATUS = 0 begin
		select @SurveyCounter += 1
		select @StatusMessage = 'Updating survey "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @SurveyCounter / @TotalSurveys
		raiserror (@StatusMessage, 0, 1, @ThisSurvey, @SurveyCounter, @TotalSurveys, @StatusPercent) with nowait

		declare @SurveyExists bit = 0;
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'

		select @SQL = N'SELECT @SurveyExistsOutput = 1; if exists (select * from ' + @ThisClient + '.sys.schemas where [name] = ''' + @ThisSurvey + ''') SELECT @SurveyExistsOutput = 1 '
		exec sp_executesql @SQL, N'@SurveyExistsOutput bit out', @SurveyExists out
		--select @SurveyExists

		if @SurveyExists = 1
		BEGIN 
		   print 'Survey Payload 1'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 2'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 3'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload03, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 4'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload04, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 5'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload05, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 6'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload06, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 7'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload07, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'All Survey Payload done!'

        END
        ELSE 
		BEGIN
		   print '  >>>>> Survey has been deleted!'
		END

		update #Survey set Processed = 1 where current of @SurveyCursor
		fetch next from @SurveyCursor into @ThisClient, @ThisSurvey
	end

	truncate table #SurveyVerif
	fetch first from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #SurveyVerif select ''' + @ThisClient + ''', SchemaName from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName from #SurveysDone'
		exec @DBSQL @SQL
		fetch next from @ClientCursor into @ThisClient
	end

	close @ClientCursor
	close @SurveyCursor
	deallocate @ClientCursor
	deallocate @SurveyCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

	IF exists (select DBName, SchemaName from #SurveyVerif except select DBName, SchemaName from #Survey where Processed = 1) 
	BEGIN
		raiserror ('  >>>>> New survey(s) have been added or were skipped, going again!', 0, 1)
		insert into #SurveysDone select DBName, SchemaName from #Survey where Processed = 1
		truncate table #DB
		truncate table #Survey
	END 
	ELSE 
    BEGIN
	  SELECT @AllDone = 1
    END

end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone